-- Fichero FDBins.sql
-------------------------------------------------------------------
-- INSTALACIN de una Base de Datos Difusa (FDB, Fuzzy Database) --
-- CREACIN de las TABLAS insercin de algunas tuplas en ellas,  --
-- as como creacin de elementos en la FMB de esta Bd           --
-- (etiquetas...).                                               --
-- Para la instalacin no hace falta desinstalarla previamente.  --
-- Debe ejecutarse por el usuario que ser propietario de las    --
-- tablas de la Bd (no necesariamente un DBA).                   --
-------------------------------------------------------------------
-- Para que salgan los mensajes (de put_line) al instalar desde FSQL*Plus:
set serveroutput on
-- Para que salgan (o no) las ordenes a ejecutar: set echo on
set echo off
-- Para que no salgan los mensajes cuando todo va bien (los errores si salen):
set feedback off

exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> ****************************************** <<<<');
exec dbms_output.put_line('>>>> **** INSTALACIN de una Base de Datos **** <<<<');
exec dbms_output.put_line('>>>> **** Difusa de ejemplo.               **** <<<<');
exec dbms_output.put_line('>>>> ****************************************** <<<<');
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> NOTAS:');
exec dbms_output.put_line('>>>>   - Es requisito indispensable que est instalado FIRST (tablas de la FMB...).');
exec dbms_output.put_line('>>>>   - No importa si se producen errores al intentar borrar');
exec dbms_output.put_line('>>>>     TABLAS que no existan (ORA-00942).');
exec dbms_output.put_line('>>>>   - Cualquier otro error podr impedir la correcta consulta a esta Bd.');
exec dbms_output.put_line('>>>>     En ese caso revise el cdigo del error y el lugar donde ha ocurrido.');
exec dbms_output.put_line('>>>>');

exec dbms_output.put_line('>>>> Borrando y Creando tabla PERSONAL...');
DROP   TABLE PERSONAL CASCADE CONSTRAINTS;
CREATE TABLE PERSONAL(
  EMP# CHAR(4) NOT NULL,
  NOMBRE CHAR (20) NOT NULL,
  SEXO CHAR(1) NOT NULL,
  EDADT NUMBER(1) DEFAULT 0 NOT NULL
      CHECK (EDADT BETWEEN 0 AND 7)
      CONSTRAINT NULL_INVALIDO_EDAD      CHECK (EDADT<>2)
      CONSTRAINT UNDEFINED_INVALIDO_EDAD CHECK (EDADT<>1),
  EDAD1 NUMBER(3),
  EDAD2 NUMBER(3),
  EDAD3 NUMBER(3),
  EDAD4 NUMBER(3),
  CIUDAD CHAR(15) NOT NULL,
  PRIMARY KEY (EMP#));

exec dbms_output.put_line('>>>> Borrando y Creando tabla APTITUD...');
DROP   TABLE APTITUD CASCADE CONSTRAINTS;
CREATE TABLE APTITUD(
  EMP# CHAR(4) NOT NULL,
  ESTUDIOST NUMBER(1) DEFAULT 0 NOT NULL
      CHECK (ESTUDIOST BETWEEN 0 AND 4),
  ESTUDIOSP1 NUMBER(3,2), -- Grado de compatibilidad para la etiqueta siguiente
  ESTUDIOS1 NUMBER(3),    -- FUZZY_OBJECT_LIST.FUZZY_ID%TYPE
  PROFT NUMBER(1) DEFAULT 0 NOT NULL
      CHECK (PROFT BETWEEN 0 AND 4),
  PROFP1 NUMBER(3,2),
  PROF1 NUMBER(3) NOT NULL, -- FUZZY_OBJECT_LIST.FUZZY_ID%TYPE
  EXPERIENCIAT NUMBER(1) DEFAULT 0 NOT NULL
      CHECK (EXPERIENCIAT BETWEEN 0 AND 7),
  EXPERIENCIA1 NUMBER(2),
  EXPERIENCIA2 NUMBER(2),
  EXPERIENCIA3 NUMBER(2),
  EXPERIENCIA4 NUMBER(2),
  PRIMARY KEY (EMP#),
  FOREIGN KEY (EMP#) REFERENCES PERSONAL ON DELETE CASCADE);

exec dbms_output.put_line('>>>> Borrando y Creando tabla DPTO...');
DROP   TABLE DPTO CASCADE CONSTRAINTS;
CREATE TABLE DPTO(
  DPTO#   CHAR(4)  NOT NULL,
  NOMBRE  CHAR(20) NOT NULL,
  LOCALIZ CHAR(15) NOT NULL,
  BENEFICIOS NUMBER(10) NOT NULL,
  PRIMARY KEY (DPTO#));

exec dbms_output.put_line('>>>> Borrando y Creando tabla PUESTOS...');
DROP   TABLE PUESTOS CASCADE CONSTRAINTS;
CREATE TABLE PUESTOS(
  PUESTO# CHAR(4) NOT NULL,
  NOMBRE CHAR(20) NOT NULL,
  ESTUDIOST NUMBER(1) NOT NULL
      CHECK (ESTUDIOST BETWEEN 0 AND 4),
  ESTUDIOSP1 NUMBER(3,2),
  ESTUDIOS1 NUMBER(3) NOT NULL,
  PROFT NUMBER(1) NOT NULL,
      CHECK (PROFT BETWEEN 0 AND 4),
  PROFP1 NUMBER(3,2),
  PROF1 NUMBER(3) NOT NULL,
  EXPERIENCIAT NUMBER(1) NOT NULL,
      CHECK (EXPERIENCIAT BETWEEN 0 AND 7),
  EXPERIENCIA1 NUMBER(2),
  EXPERIENCIA2 NUMBER(2),
  EXPERIENCIA3 NUMBER(2),
  EXPERIENCIA4 NUMBER(2),
  PRIMARY KEY (PUESTO#));

exec dbms_output.put_line('>>>> Borrando y Creando tabla EMPLEOS...');
DROP   TABLE EMPLEOS;
CREATE TABLE EMPLEOS(
  EMP# CHAR(4) NOT NULL,
  DPTO# CHAR(4) NOT NULL,
  PUESTO# CHAR(4) NOT NULL,
  SUELDO NUMBER(7) NOT NULL,
  COMISIONT NUMBER(1) NOT NULL,
      CHECK (COMISIONT BETWEEN 0 AND 7),
  COMISION1 NUMBER(7),
  COMISION2 NUMBER(7),
  COMISION3 NUMBER(7),
  COMISION4 NUMBER(7),
  RENDIMIENTOT NUMBER(1) NOT NULL,
      CHECK (RENDIMIENTOT BETWEEN 0 AND 4),
  RENDIMIENTOP1 NUMBER(3,2),
  RENDIMIENTO1 NUMBER(3) NOT NULL,
  PRIMARY KEY (EMP#,DPTO#,PUESTO#),
  FOREIGN KEY (EMP#) REFERENCES PERSONAL ON DELETE CASCADE,
  FOREIGN KEY (EMP#) REFERENCES APTITUD ON DELETE CASCADE,
  FOREIGN KEY (DPTO#) REFERENCES DPTO ON DELETE CASCADE,
  FOREIGN KEY (PUESTO#) REFERENCES PUESTOS ON DELETE CASCADE);

exec dbms_output.put_line('>>>> Borrando y Creando tabla CIUDADES...');
DROP   TABLE CIUDADES;
CREATE TABLE CIUDADES(
  CIUDAD1 CHAR(15) NOT NULL,
  CIUDAD2 CHAR(15) NOT NULL,
  DISTANCIA NUMBER(5) NOT NULL,
  PRIMARY KEY (CIUDAD1,CIUDAD2));

exec dbms_output.put_line('>>>> Borrando y Creando tabla REQUISITOS...');
-- Requisitos buscados en ofertas de empleo (LEN=4)
DROP   TABLE REQUISITOS;
CREATE TABLE REQUISITOS(
  Clave      INTEGER   NOT NULL,
  ESTUDIOST  NUMBER(1) NOT NULL,
      CHECK (ESTUDIOST BETWEEN 0 AND 4),
  ESTUDIOSP1 NUMBER(3,2),
  ESTUDIOS1  NUMBER(3),
  ESTUDIOSP2 NUMBER(3,2),
  ESTUDIOS2  NUMBER(3),
  ESTUDIOSP3 NUMBER(3,2),
  ESTUDIOS3  NUMBER(3),
  ESTUDIOSP4 NUMBER(3,2),
  ESTUDIOS4  NUMBER(3),
  PRIMARY KEY (Clave));

DECLARE
  t_APTITUD    NUMBER;
  t_EMPLEOS    NUMBER;
  t_PUESTOS    NUMBER;
  t_CIUDADES   NUMBER;
  t_DPTO       NUMBER;
  t_PERSONAL   NUMBER;
  t_REQUISITOS NUMBER;
  c_req_estudios NUMBER;
  c_estudios     NUMBER;
  c_experiencia  NUMBER;
  c_prof         NUMBER;
  c_comision     NUMBER;
  c_rendimiento  NUMBER;
  c_sueldo       NUMBER;
  c_estudios1    NUMBER;
  c_experiencia1 NUMBER;
  c_prof1        NUMBER;
  c_distancia    NUMBER;
  c_beneficios   NUMBER;
  c_edad         NUMBER;
BEGIN
  dbms_output.put_line('>>>> Insertando valores en la FMB sobre esta Bd Difusa...');

  -- Calcular OBJ# para las tablas con columnas difusas:
  SELECT object_id into t_APTITUD FROM user_objects WHERE object_name='APTITUD';
  SELECT object_id into t_EMPLEOS FROM user_objects WHERE object_name='EMPLEOS';
  SELECT object_id into t_PUESTOS FROM user_objects WHERE object_name='PUESTOS';
  SELECT object_id into t_CIUDADES   FROM user_objects WHERE object_name='CIUDADES';
  SELECT object_id into t_DPTO       FROM user_objects WHERE object_name='DPTO';
  SELECT object_id into t_PERSONAL   FROM user_objects WHERE object_name='PERSONAL';
  SELECT object_id into t_REQUISITOS FROM user_objects WHERE object_name='REQUISITOS';

  -- Calcular COL# de las columnas difusas:
  SELECT column_id into c_estudios
    FROM user_tab_columns WHERE table_name='APTITUD' AND column_name='ESTUDIOST';
  SELECT column_id into c_experiencia
    FROM user_tab_columns WHERE table_name='APTITUD' AND column_name='EXPERIENCIAT';
  SELECT column_id into c_prof
    FROM user_tab_columns WHERE table_name='APTITUD' AND column_name='PROFT';
  SELECT column_id into c_comision
    FROM user_tab_columns WHERE table_name='EMPLEOS' AND column_name='COMISIONT';
  SELECT column_id into c_rendimiento
    FROM user_tab_columns WHERE table_name='EMPLEOS' AND column_name='RENDIMIENTOT';
  SELECT column_id into c_sueldo
    FROM user_tab_columns WHERE table_name='EMPLEOS' AND column_name='SUELDO';
  SELECT column_id into c_estudios1
    FROM user_tab_columns WHERE table_name='PUESTOS' AND column_name='ESTUDIOST';
  SELECT column_id into c_experiencia1
    FROM user_tab_columns WHERE table_name='PUESTOS' AND column_name='EXPERIENCIAT';
  SELECT column_id into c_prof1
    FROM user_tab_columns WHERE table_name='PUESTOS' AND column_name='PROFT';
  SELECT column_id into c_distancia
    FROM user_tab_columns WHERE table_name='CIUDADES' AND column_name='DISTANCIA';
  SELECT column_id into c_beneficios
    FROM user_tab_columns WHERE table_name='DPTO' AND column_name='BENEFICIOS';
  SELECT column_id into c_edad
    FROM user_tab_columns WHERE table_name='PERSONAL' AND column_name='EDADT';
  SELECT column_id into c_req_estudios
    FROM user_tab_columns WHERE table_name='REQUISITOS' AND column_name='ESTUDIOST';

  -- Atributos con tratamiento difuso: Tipos 1, 2  3
  INSERT into FCL values (t_APTITUD,c_estudios,3,1,USER||'.APTITUD.ESTUDIOS');
  INSERT into FCL values (t_APTITUD,c_experiencia,2,1,USER||'.APTITUD.EXPERIENCIA');
  INSERT into FCL values (t_APTITUD,c_prof,3,1,USER||'.APTITUD.PROF');
  INSERT into FCL values (t_EMPLEOS,c_comision,2,1,USER||'.EMPLEOS.COMISION');
  INSERT into FCL values (t_EMPLEOS,c_rendimiento,3,1,USER||'.EMPLEOS.RENDIMIENTO');
  INSERT into FCL values (t_EMPLEOS,c_sueldo,1,1,USER||'.EMPLEOS.SUELDO');
  INSERT into FCL values (t_PUESTOS,c_estudios1,3,1,USER||'.PUESTOS.ESTUDIOS');
  INSERT into FCL values (t_PUESTOS,c_experiencia1,2,1,USER||'.PUESTOS.EXPERIENCIA');
  INSERT into FCL values (t_PUESTOS,c_prof1,3,1,USER||'.PUESTOS.PROF');
  INSERT into FCL values (t_CIUDADES,c_distancia,1,1,USER||'.CIUDADES.DISTANCIA');
  INSERT into FCL values (t_DPTO,c_beneficios,1,1,USER||'.DPTO.BENEFICIOS');
  INSERT into FCL values (t_PERSONAL,c_edad,2,1,USER||'.PERSONAL.EDAD');
  INSERT into FCL values (t_REQUISITOS,c_req_estudios,3,4,USER||'.REQUISITOS.ESTUDIOS'); -- LEN=4

  -- COMPATIBILIDAD de atributos tipo 3:
  -- El campo estudios de la tabla REQUISITOS es compatible con
  -- el campo estudios de la tabla APTITUD (puede tomar el valor de sus mismas etiquetas)
  INSERT into FCC values (t_REQUISITOS,c_req_estudios,t_APTITUD,c_estudios);
  -- Campo PUESTOS.estudios es compatible con APTITUD.estudios
  INSERT into FCC values (t_PUESTOS,c_estudios1,t_APTITUD,c_estudios);
  -- Campo PUESTOS.prof es compatible con APTITUD.prof
  INSERT into FCC values (t_PUESTOS,c_prof1,t_APTITUD,c_prof);

  -- Objetos para la tabla EMPLEOS:
  INSERT into FOL values (t_EMPLEOS,c_sueldo,0,'BAJO',0);
  INSERT into FOL values (t_EMPLEOS,c_sueldo,1,'MEDIO',0);
  INSERT into FOL values (t_EMPLEOS,c_sueldo,2,'ALTO',0);
  INSERT into FOL values (t_EMPLEOS,c_sueldo,3,'MUY_ALTO',0);
  INSERT into FOL values (t_EMPLEOS,c_comision,0,'REDUCIDA',0);
  INSERT into FOL values (t_EMPLEOS,c_comision,1,'BAJA',0);
  INSERT into FOL values (t_EMPLEOS,c_comision,2,'NORMAL',0);
  INSERT into FOL values (t_EMPLEOS,c_comision,3,'ALTA',0);
  INSERT into FOL values (t_EMPLEOS,c_comision,4,'ELEVADA',0);
  INSERT into FOL values (t_EMPLEOS,c_rendimiento,0,'MALO',1);
  INSERT into FOL values (t_EMPLEOS,c_rendimiento,1,'REGULAR',1);
  INSERT into FOL values (t_EMPLEOS,c_rendimiento,2,'BUENO',1);
  INSERT into FOL values (t_EMPLEOS,c_rendimiento,3,'EXCELENTE',1);

  -- Objetos para la tabla APTITUD:
  INSERT into FOL values(t_APTITUD,c_estudios,0,'SECUNDARIA',1);
  INSERT into FOL values(t_APTITUD,c_estudios,1,'DIPLOMADO',1);
  INSERT into FOL values(t_APTITUD,c_estudios,2,'LICENCIADO',1);
  INSERT into FOL values(t_APTITUD,c_estudios,3,'DOCTOR',1);
  INSERT into FOL values(t_APTITUD,c_prof,0,'DIRECTOR',1);
  INSERT into FOL values(t_APTITUD,c_prof,1,'INGENIERO',1);
  INSERT into FOL values(t_APTITUD,c_prof,2,'TECNICO',1);
  INSERT into FOL values(t_APTITUD,c_prof,3,'ADMINISTRATIVO',1);
  INSERT into FOL values(t_APTITUD,c_prof,4,'SECRETARIO',1);
  INSERT into FOL values(t_APTITUD,c_prof,5,'VENDEDOR',1);
  INSERT into FOL values(t_APTITUD,c_experiencia,0,'POCA',0);
  INSERT into FOL values(t_APTITUD,c_experiencia,1,'ALGUNA',0);
  INSERT into FOL values(t_APTITUD,c_experiencia,2,'MUCHA',0);
  INSERT into FOL values(t_APTITUD,c_experiencia,3,'BASTANTE',0);
  INSERT into FOL values(t_APTITUD,c_experiencia,4,'GRANDE',0);

  -- Objetos para la tabla PUESTOS:
  INSERT into FOL values(t_PUESTOS,c_experiencia1,0,'POCA',0);
  INSERT into FOL values(t_PUESTOS,c_experiencia1,1,'ALGUNA',0);
  INSERT into FOL values(t_PUESTOS,c_experiencia1,2,'MUCHA',0);
  INSERT into FOL values(t_PUESTOS,c_experiencia1,3,'BASTANTE',0);
  INSERT into FOL values(t_PUESTOS,c_experiencia1,4,'GRANDE',0);

  -- Objetos para la tabla DPTO:
  INSERT into FOL values(t_DPTO,c_beneficios,0,'ESCASOS',0);
  INSERT into FOL values(t_DPTO,c_beneficios,1,'POCOS',0);
  INSERT into FOL values(t_DPTO,c_beneficios,2,'MODERADOS',0);
  INSERT into FOL values(t_DPTO,c_beneficios,3,'ELEVADOS',0);

  -- Objetos para la tabla PERSONAL:
  INSERT into FOL values(t_PERSONAL,c_edad,0,'MUY_JOVEN',0);
  INSERT into FOL values(t_PERSONAL,c_edad,1,'JOVEN',0);
  INSERT into FOL values(t_PERSONAL,c_edad,2,'MADURO',0);
  INSERT into FOL values(t_PERSONAL,c_edad,3,'MAYOR',0);
  INSERT into FOL values(t_PERSONAL,c_edad,4,'MUY_MAYOR',0);

  -- Objetos para la tabla CIUDADES:
  INSERT into FOL values(t_CIUDADES,c_distancia,0,'MUY_CORTA',0);
  INSERT into FOL values(t_CIUDADES,c_distancia,1,'CORTA',0);
  INSERT into FOL values(t_CIUDADES,c_distancia,2,'MEDIA',0);
  INSERT into FOL values(t_CIUDADES,c_distancia,3,'LARGA',0);
  INSERT into FOL values(t_CIUDADES,c_distancia,4,'MUY_LARGA',0);
  INSERT into FOL values(t_CIUDADES,c_distancia,5,'LA_MAYOR',0);

  -- Definicin de las etiquetas lingsticas:
  INSERT into FLD values(t_PERSONAL,c_edad,0,16,16,20,26);
  INSERT into FLD values(t_PERSONAL,c_edad,1,18,22,30,35);
  INSERT into FLD values(t_PERSONAL,c_edad,2,25,32,45,50);
  INSERT into FLD values(t_PERSONAL,c_edad,3,40,45,55,60);
  INSERT into FLD values(t_PERSONAL,c_edad,4,50,55,62,70);
  INSERT into FLD values(t_PUESTOS,c_experiencia1,0,0,1,2,4); 
  INSERT into FLD values(t_PUESTOS,c_experiencia1,1,2,3,5,6);
  INSERT into FLD values(t_PUESTOS,c_experiencia1,2,5,7,10,12);
  INSERT into FLD values(t_PUESTOS,c_experiencia1,3,7,8,15,20);
  INSERT into FLD values(t_PUESTOS,c_experiencia1,4,12,15,50,50);
  INSERT into FLD values(t_APTITUD,c_experiencia,0,0,1,2,4);
  INSERT into FLD values(t_APTITUD,c_experiencia,1,2,3,5,6);
  INSERT into FLD values(t_APTITUD,c_experiencia,2,5,7,10,12);
  INSERT into FLD values(t_APTITUD,c_experiencia,3,7,8,15,20);
  INSERT into FLD values(t_APTITUD,c_experiencia,4,12,15,50,50);

  INSERT into FLD values(t_DPTO,c_beneficios,0,0,10000000,20000000,30000000);
  INSERT into FLD values(t_DPTO,c_beneficios,1,15000000,30000000,50000000,70000000);

  INSERT into FLD values(t_DPTO,c_beneficios,2,30000000,45000000,100000000,140000000);
  INSERT into FLD values(t_DPTO,c_beneficios,3,70000000,100000000,1000000000,1000000000);

  INSERT into FLD values(t_EMPLEOS,c_sueldo,0,50000,55000,80000,120000);
  INSERT into FLD values(t_EMPLEOS,c_sueldo,1,70000,90000,170000,200000);
  INSERT into FLD values(t_EMPLEOS,c_sueldo,2,160000,180000,250000,300000);
  INSERT into FLD values(t_EMPLEOS,c_sueldo,3,200000,240000,1000000,1000000);
  INSERT into FLD values(t_EMPLEOS,c_comision,0,0,5000,10000,15000);
  INSERT into FLD values(t_EMPLEOS,c_comision,1,11000,15000,20000,30000);
  INSERT into FLD values(t_EMPLEOS,c_comision,2,15000,17000,30000,40000);
  INSERT into FLD values(t_EMPLEOS,c_comision,3,20000,32000,50000,60000);
  INSERT into FLD values(t_EMPLEOS,c_comision,4,40000,50000,200000,300000);

  INSERT into FLD values(t_CIUDADES,c_distancia,0,0,0,70,100);
  INSERT into FLD values(t_CIUDADES,c_distancia,1,70,100,150,200);
  INSERT into FLD values(t_CIUDADES,c_distancia,2,100,150,250,300);
  INSERT into FLD values(t_CIUDADES,c_distancia,3,150,200,450,600);
  INSERT into FLD values(t_CIUDADES,c_distancia,4,300,400,1000,1500);
  INSERT into FLD values(t_CIUDADES,c_distancia,5,1000,1500,99999,99999);

  -- Definicin de las relaciones de semejanza:
  INSERT into FND values(t_APTITUD,c_estudios,0,1,.5);
  INSERT into FND values(t_APTITUD,c_estudios,0,2,.2);
  INSERT into FND values(t_APTITUD,c_estudios,0,3,.1);
  INSERT into FND values(t_APTITUD,c_estudios,1,2,.6);
  INSERT into FND values(t_APTITUD,c_estudios,1,3,.3);
  INSERT into FND values(t_APTITUD,c_estudios,2,3,.8);
  INSERT into FND values(t_APTITUD,c_prof,0,1,.8);
  INSERT into FND values(t_APTITUD,c_prof,0,2,.7);
  INSERT into FND values(t_APTITUD,c_prof,0,3,.6);
  INSERT into FND values(t_APTITUD,c_prof,0,4,.4);
  INSERT into FND values(t_APTITUD,c_prof,0,5,.4);
  INSERT into FND values(t_APTITUD,c_prof,1,2,.8);
  INSERT into FND values(t_APTITUD,c_prof,1,3,.2);
  INSERT into FND values(t_APTITUD,c_prof,1,4,.2);
  INSERT into FND values(t_APTITUD,c_prof,1,5,.2);
  INSERT into FND values(t_APTITUD,c_prof,2,3,.8);
  INSERT into FND values(t_APTITUD,c_prof,2,4,.6);
  INSERT into FND values(t_APTITUD,c_prof,2,5,.5);
  INSERT into FND values(t_APTITUD,c_prof,3,4,.7);
  INSERT into FND values(t_APTITUD,c_prof,3,5,.6);
  INSERT into FND values(t_APTITUD,c_prof,4,5,.6);

  INSERT into FND values(t_EMPLEOS,c_rendimiento,0,1,.8);
  INSERT into FND values(t_EMPLEOS,c_rendimiento,0,2,.5);
  INSERT into FND values(t_EMPLEOS,c_rendimiento,0,3,.1);
  INSERT into FND values(t_EMPLEOS,c_rendimiento,1,2,.7);
  INSERT into FND values(t_EMPLEOS,c_rendimiento,1,3,.5);
  INSERT into FND values(t_EMPLEOS,c_rendimiento,2,3,.8);

  -- Definicin de:	1) Mrgenes para valores APROX en cada columna y
  --				2) Distancia Mnima para afirmar en los comparadores MGT y MLT.
  INSERT into FAM values(t_PERSONAL,c_edad,5,10);
  -- En EDAD:	1) Si decimos "Aproximadamente 15 aos", entendemos 155
  --			2) Para que dos edades sean MUY diferentes (MGT  MLT), tendrn que diferir en 10 aos
  INSERT into FAM values(t_APTITUD,c_experiencia,2,5);
  INSERT into FAM values(t_DPTO,c_beneficios,10000000,30000000);
  INSERT into FAM values(t_PUESTOS,c_experiencia1,2,5);
  INSERT into FAM values(t_EMPLEOS,c_sueldo,10000,50000);
  INSERT into FAM values(t_EMPLEOS,c_comision,5000,15000);
  INSERT into FAM values(t_CIUDADES,c_distancia,25,100);

  dbms_output.put_line('>>>> Insertando valores en las tablas de esta Bd Difusa...');
  -- *****  INSERCIONES de los valores de las tablas ***** --
  INSERT into PERSONAL values ('E0' ,'VICTOR'  ,'V',4,0,NULL ,NULL,NULL,'BARCELONA');
  INSERT into PERSONAL values ('E1' ,'SIXTO'   ,'V',3,17,NULL ,NULL,NULL,'GRANADA');
  INSERT into PERSONAL values ('E2' ,'OLGA'    ,'H',3,27,NULL ,NULL,NULL,'GRANADA');
  INSERT into PERSONAL values ('E3' ,'JOSE'    ,'V',5,25,0,0,30,'MALAGA');
  INSERT into PERSONAL values ('E4' ,'SALVADOR','V',7,40,5,-7,55,'VALENCIA');
  INSERT into PERSONAL values ('E5' ,'MATILDE' ,'H',6,30,25,35,5,'MADRID');
  INSERT into PERSONAL values ('E6' ,'ANA'     ,'H',0,23,NULL,NULL,NULL,'BARCELONA');
  INSERT into PERSONAL values ('E7' ,'CANDIDO' ,'V',3,45,NULL,NULL,NULL,'GRANADA');
  INSERT into PERSONAL values ('E8' ,'LUIS'    ,'V',3,18,NULL,NULL,NULL,'MALAGA');
  INSERT into PERSONAL values ('E9' ,'FEDERICO','V',3,23,NULL,NULL,NULL,'VALENCIA');
  INSERT into PERSONAL values ('E10','ALVARO'  ,'V',4,1,NULL,NULL,NULL,'GRANADA');
  INSERT into PERSONAL values ('E11','ELADIO'  ,'V',4,3,NULL,NULL,NULL,'MADRID');
  INSERT into PERSONAL values ('E12','CARLOS'  ,'V',4,4,NULL,NULL,NULL,'MADRID');
  INSERT into PERSONAL values ('E13','CRISTINA','H',4,2,NULL,NULL,NULL,'MALAGA');
  INSERT into PERSONAL values ('E14','INES'    ,'H',4,1,NULL,NULL,NULL,'VALENCIA');
  INSERT into PERSONAL values ('E15','JULIAN'  ,'V',3,31,NULL,NULL,NULL,'BARCELONA');
  INSERT into PERSONAL values ('E16','ANTONIO' ,'V',3,55,NULL,NULL,NULL,'MALAGA');
  INSERT into PERSONAL values ('E17','SILVIA'  ,'H',6,35,30,40,5,'VALENCIA');
  INSERT into PERSONAL values ('E18','PALOMA'  ,'H',3,27,NULL,NULL,NULL,'GRANADA');
  INSERT into PERSONAL values ('E19','DAVID YAHYA','V',4,1,NULL,NULL,NULL,'GRANADA');
  INSERT into PERSONAL values ('E20','PATON'   ,'V',3,60,NULL,NULL,NULL,'CASTELLAR');
  INSERT into PERSONAL values ('E21','JUANLU'  ,'V',3,48,NULL,NULL,NULL,'MARMOLEJO');
  INSERT into PERSONAL values ('E22','RAFA'    ,'V',3,17,NULL,NULL,NULL,'JAMILENA');
  INSERT into PERSONAL values ('E23','D. JOSE' ,'V',3,4,NULL,NULL,NULL,'GRANADA');
  INSERT into PERSONAL values ('E24','PATRICIA','H',3,27,NULL,NULL,NULL,'GRANADA');

  INSERT into APTITUD values ('E0' ,3,1,0,3,1,5,4,0,NULL,NULL,NULL);
  INSERT into APTITUD values ('E1' ,3,1,0,3,1,3,4,0,NULL,NULL,NULL);
  INSERT into APTITUD values ('E2' ,3,1,2,3,1,1,4,1,NULL,NULL,NULL);
  INSERT into APTITUD values ('E3' ,3,1,2,3,1,3,3,3,NULL,NULL,NULL);
  INSERT into APTITUD values ('E4' ,3,1,1,3,1,5,3,20,NULL,NULL,NULL);
  INSERT into APTITUD values ('E5' ,3,1,1,3,1,5,3,5,NULL,NULL,NULL);
  INSERT into APTITUD values ('E6' ,3,1,0,3,1,4,0,23,NULL,NULL,NULL);
  INSERT into APTITUD values ('E7' ,3,1,3,3,1,0,4,3,NULL,NULL,NULL);
  INSERT into APTITUD values ('E8' ,3,1,1,3,1,5,3,1,NULL,NULL,NULL);
  INSERT into APTITUD values ('E9' ,3,1,1,3,1,3,6,2,0,4,2);
  INSERT into APTITUD values ('E10',3,1,1,3,1,4,4,1,NULL,NULL,NULL);
  INSERT into APTITUD values ('E11',3,1,2,3,1,0,4,3,NULL,NULL,NULL);
  INSERT into APTITUD values ('E12',3,1,2,3,1,1,3,20,NULL,NULL,NULL);
  INSERT into APTITUD values ('E13',3,1,3,3,1,0,3,15,NULL,NULL,NULL);
  INSERT into APTITUD values ('E14',3,1,1,3,1,4,6,3,1,5,2);
  INSERT into APTITUD values ('E15',3,1,2,3,1,1,7,2,4,-4,17);
  INSERT into APTITUD values ('E16',3,1,1,3,1,3,4,3,NULL,NULL,NULL);
  INSERT into APTITUD values ('E17',3,1,2,3,1,1,3,7,NULL,NULL,NULL);
  INSERT into APTITUD values ('E18',3,1,2,3,1,2,3,4,NULL,NULL,NULL);
  INSERT into APTITUD values ('E19',3,1,1,3,1,5,4,1,NULL,NULL,NULL);
  INSERT into APTITUD values ('E20',3,1,2,3,1,2,4,4,NULL,NULL,NULL);
  INSERT into APTITUD values ('E21',3,1,2,3,1,2,4,3,NULL,NULL,NULL);
  INSERT into APTITUD values ('E22',3,1,0,3,1,4,5,15,NULL,NULL,20);
  INSERT into APTITUD values ('E23',3,1,0,3,1,4,4,2,NULL,NULL,NULL);
  INSERT into APTITUD values ('E24',3,1,0,3,1,4,6,15,13,17,2);

  INSERT into DPTO values ('D0','EXPORTACION','MADRID',35000000);
  INSERT into DPTO values ('D1','CENTRO'     ,'MADRID',30000000);
  INSERT into DPTO values ('D2','SUR'        ,'MALAGA',40000000);
  INSERT into DPTO values ('D3','NORTE'   ,'BARCELONA',35000000);
  INSERT into DPTO values ('D4','LEVANTE'  ,'VALENCIA',10000000);

  INSERT into PUESTOS values ('P0','DIRECTOR' ,3,1,2,3,1,0,4,4,NULL ,NULL,NULL);
  INSERT into PUESTOS values ('P1','INGENIERO',3,1,2,3,1,1,4,3,NULL ,NULL,NULL);
  INSERT into PUESTOS values ('P2','TECNICO'  ,3,1,2,3,1,2,4,3,NULL ,NULL,NULL);
  INSERT into PUESTOS values ('P3','ADMINISTRATIVO',3,1,1,3,1,3,4,0 ,NULL,NULL,NULL);
  INSERT into PUESTOS values ('P4','SECRETARIO',3,1,1,3,1,4,4,1,NULL,NULL,NULL);
  INSERT into PUESTOS values ('P5','VENDEDOR'  ,3,1,0,3,1,5,4,2,NULL,NULL,NULL);
  INSERT into PUESTOS values ('P6','Vendedor Aux1',3,1,0,3,1,5,3,0,NULL,NULL,NULL);
  INSERT into PUESTOS values ('P7','Vendedor Aux2',3,1,0,3,1,5,0,NULL,NULL,NULL,NULL);
  INSERT into PUESTOS values ('P8','Vendedor Aux3',3,1,0,3,1,5,1,NULL,NULL,NULL,NULL);
  INSERT into PUESTOS values ('P9','Vendedor Aux4',3,1,0,3,1,5,2,NULL,NULL,NULL,NULL);

  INSERT into EMPLEOS values ('E0' ,'D1','P5', 60000,3,10000,NULL,NULL,NULL,3,1,1);
  INSERT into EMPLEOS values ('E1' ,'D1','P3', 80000,3,5000,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E2' ,'D3','P1',200000,4,2,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E3' ,'D4','P3',120000,3,10000,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E4' ,'D0','P5',160000,4,3,NULL,NULL,NULL,3,1,3);
  INSERT into EMPLEOS values ('E5' ,'D2','P5',140000,3,30000,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E6' ,'D0','P4',120000,4,0,NULL,NULL,NULL,3,1,1);
  INSERT into EMPLEOS values ('E7' ,'D0','P0',500000,4,4,NULL,NULL,NULL,3,1,3);
  INSERT into EMPLEOS values ('E8' ,'D2','P5', 90000,3,35000,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E9' ,'D1','P3',120000,6,5000,0,10000,5000,3,1,2);
  INSERT into EMPLEOS values ('E10','D3','P4',110000,4,1,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E11','D1','P0',450000,4,4,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E12','D3','P1',350000,3,40000,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E13','D4','P0',475000,3,50000,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E14','D3','P4',100000,4,1,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E15','D2','P1',230000,7,50000,10000,-15000,100000,3,1,2);
  INSERT into EMPLEOS values ('E16','D1','P3',170000,4,2,NULL,NULL,NULL,3,1,3);
  INSERT into EMPLEOS values ('E17','D3','P1',180000,4,0,NULL,NULL,NULL,3,1,0);
  INSERT into EMPLEOS values ('E18','D2','P2',160000,3,20000,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E19','D2','P5',130000,4,3,NULL,NULL,NULL,3,1,3);
  INSERT into EMPLEOS values ('E20','D0','P2',230000,4,2,NULL,NULL,NULL,3,1,2);
  INSERT into EMPLEOS values ('E21','D3','P2',270000,6,25000,20000,30000,5000,3,1,2);
  INSERT into EMPLEOS values ('E22','D1','P4', 85000,4,1,NULL,NULL,NULL,3,1,2);

  INSERT into CIUDADES values ('BARCELONA','MADRID'  ,621);
  INSERT into CIUDADES values ('BARCELONA','MALAGA'  ,995);
  INSERT into CIUDADES values ('BARCELONA','GRANADA' ,875);
  INSERT into CIUDADES values ('BARCELONA','VALENCIA',352);
  INSERT into CIUDADES values ('BARCELONA','ROMA',1466);
  INSERT into CIUDADES values ('MADRID'   ,'MALAGA'  ,542);
  INSERT into CIUDADES values ('MADRID'   ,'GRANADA' ,432);
  INSERT into CIUDADES values ('MADRID'   ,'VALENCIA',350);
  INSERT into CIUDADES values ('MADRID'   ,'MARSELLA',1200);
  INSERT into CIUDADES values ('MALAGA'   ,'GRANADA' ,128);
  INSERT into CIUDADES values ('MALAGA'   ,'VALENCIA',643);
  INSERT into CIUDADES values ('MALAGA'   ,'PARS',1830);
  INSERT into CIUDADES values ('GRANADA'  ,'VALENCIA',528);
  INSERT into CIUDADES values ('GRANADA'  ,'ALMERA',175);
  INSERT into CIUDADES values ('GRANADA'  ,'PONTEVEDRA',1057);
  INSERT into CIUDADES values ('GRANADA'  ,'SANTA FE',6);

  INSERT into REQUISITOS values (0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL); -- Unknown
  INSERT into REQUISITOS values (1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL); -- Undefined
  INSERT into REQUISITOS values (2,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL); -- Null
  INSERT into REQUISITOS values (3,3,1,0,NULL,NULL,NULL,NULL,NULL,NULL); -- 1/SECUNDARIA(Label)
  INSERT into REQUISITOS values (4,3,1,1,NULL,NULL,NULL,NULL,NULL,NULL); -- 1/DIPLOMADO
  INSERT into REQUISITOS values (5,3,1,2,NULL,NULL,NULL,NULL,NULL,NULL); -- 1/LICENCIADO
  INSERT into REQUISITOS values (6,3,.9,3,NULL,NULL,NULL,NULL,NULL,NULL);-- .9/DOCTOR
  INSERT into REQUISITOS values (7,4,.7,2,NULL,NULL,NULL,NULL,NULL,NULL);-- .7/LICENCIADO (Dist. Pos.)
  INSERT into REQUISITOS values (8,4,.2,0,.6,1,1,2,.8,3);-- .2/SEC.,.6/DIP.,1/LIC.,.8/DOCTOR
  INSERT into REQUISITOS values (9,4,.4,1,.7,2,.9,3,NULL,NULL); -- .4/DIP.,.7/LIC.,.9/DOCTOR

  COMMIT;
END;
/

-- Mensaje de FIN:
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> FIN de la INSTALACIN: Si existieron errores, revise su texto.');
exec dbms_output.put_line('>>>>');

-- Reestablecer los valores por defecto:
set serveroutput off
set feedback on
